import sys
import heapq

def solve():
    input = sys.stdin.readline
    N = int(input())
    xs = list(map(int, input().split()))
    left = []
    right = []
    for x in xs:
        if x < 0:
            heapq.heappush(left, -x)
        elif x > 0:
            heapq.heappush(right, x)
        else:
            print(0)
            print("")
            return
    moves = []
    last_move = None
    killed = 0
    steps = 0
    MAX_STEPS = 10**6
    while steps < MAX_STEPS:
        if (left and left[0] <= 0) or (right and right[0] <= 0):
            break
        if not left and not right:
            break
        next_dir = None
        if left and right:
            if left[0] <= right[0]:
                next_dir = 2
            else:
                next_dir = 1
        elif right:
            next_dir = 1
        else:
            next_dir = 2
        if last_move == next_dir:
            if last_move != 3:
                move = 3
            else:
                move = 1
        else:
            move = next_dir
        if move == 1:
            if right:
                heapq.heappop(right)
                killed += 1
        elif move == 2:
            if left:
                heapq.heappop(left)
                killed += 1
        else:
            pass
        moves.append(str(move))
        last_move = move
        steps += 1
        left = [d - 1 for d in left]
        right = [d - 1 for d in right]
        heapq.heapify(left)
        heapq.heapify(right)
    print(killed)
    print("".join(moves))
if __name__ == "__main__":
    solve()